
// SC5C0N1_VANCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC5C0N1_VANC.h"
#include "SC5C0N1_VANCDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC5C0N1_VANCDlg * pMainDlg = (CSC5C0N1_VANCDlg *)(pUserData);

	pMainDlg->m_nVideoWidth = 0;
	
	pMainDlg->m_nVideoHeight = 0;
	
	pMainDlg->m_bVideoIsInterleaved = FALSE;
	
	pMainDlg->m_dVideoFrameRate = 0.0;
	
	pMainDlg->m_nAudioChannels = 0; 
	
	pMainDlg->m_nAudioBitsPerSample = 0;
	
	pMainDlg->m_nAudioSampleFrequency = 0;

	pMainDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CSC5C0N1_VANCDlg * pMainDlg = (CSC5C0N1_VANCDlg *)(pUserData);

	pMainDlg->m_nVideoWidth = 0;
	
	pMainDlg->m_nVideoHeight = 0;
	
	pMainDlg->m_bVideoIsInterleaved = FALSE;
	
	pMainDlg->m_dVideoFrameRate = 0.0;
	
	pMainDlg->m_nAudioChannels = 0; 
	
	pMainDlg->m_nAudioBitsPerSample = 0;
	
	pMainDlg->m_nAudioSampleFrequency = 0;

	pMainDlg->SetTimer( 0x00000000, 1, NULL );	

	return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CSC5C0N1_VANCDlg * pMainDlg = (CSC5C0N1_VANCDlg *)(pUserData);

	pMainDlg->m_nVideoWidth = nVideoWidth;
	
	pMainDlg->m_nVideoHeight = nVideoHeight;
	
	pMainDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;
	
	pMainDlg->m_dVideoFrameRate = dVideoFrameRate;
	
	pMainDlg->m_nAudioChannels = nAudioChannels; 
	
	pMainDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;
	
	pMainDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;

	if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

	pMainDlg->m_strFormatChangedOutput.Format( "INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ",

													nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency);

	pMainDlg->SetTimer( 0x00000000, 1, NULL );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC5C0N1_VANCDlg * pMainDlg = (CSC5C0N1_VANCDlg *)(pUserData);

	if( (nFrameBufferLen > 0) && (pMainDlg->display == true))
	{
		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, pMainDlg->m_nVideoWidth, pMainDlg->m_nVideoHeight, pFrameBuffer, nFrameBufferLen );
	}

	return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	CSC5C0N1_VANCDlg * pMainDlg = (CSC5C0N1_VANCDlg *)(pUserData);
	
	if( (nFrameBufferLen > 0) && (pMainDlg->display == true))
	{
		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
	}

    return QCAP_RT_OK;
}


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


// CSC5C0N1_VANCDlg dialog




CSC5C0N1_VANCDlg::CSC5C0N1_VANCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC5C0N1_VANCDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSC5C0N1_VANCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_WINDOW, m_DisplayWindow);
	DDX_Control(pDX, IDC_STATIC_INFO, m_statInfo);
}

BEGIN_MESSAGE_MAP(CSC5C0N1_VANCDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_TIMER()
END_MESSAGE_MAP()


// CSC5C0N1_VANCDlg message handlers

BOOL CSC5C0N1_VANCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MEMBER VARIABLES
	//
	m_pDevice = NULL;

	display = false;

	m_nVideoWidth = 0;
	
	m_nVideoHeight = 0;
	
	m_bVideoIsInterleaved = FALSE;
	
	m_dVideoFrameRate = 0.0;
	
	m_nAudioChannels = 0; 
	
	m_nAudioBitsPerSample = 0;
	
	m_nAudioSampleFrequency = 0;

	// INITIALIZE DEVICE RESOURCE
	//
	QCAP_CREATE( "MZ0380 PCI", 0, NULL, &m_pDevice, TRUE );

	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_process_format_changed, this );

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_process_no_signal_detected, this);

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_process_signal_removed, this);

	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_audio_preview_callback, this );

	QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_AUTO );

	QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	// SET OUTPUT YUY2
	//
	QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT(m_pDevice, QCAP_COLORSPACE_TYEP_YUY2, 0, 0, 0, 0);

	// SET VANC LINES
	//
	QCAP_SET_VIDEO_VERTICAL_ANCILLARY_DATA_GRABBED_LINES( m_pDevice, 36 );

	// ENABLE VANC
	//
	QCAP_SET_DEVICE_CUSTOM_PROPERTY( m_pDevice, 236, TRUE ); //jimmytest VANC ENABLE

	QCAP_RUN( m_pDevice );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSC5C0N1_VANCDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC5C0N1_VANCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC5C0N1_VANCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



void CSC5C0N1_VANCDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: Add your message handler code here

	KillTimer( 0x00000000 );

	if(display == TRUE)
	{
		QCAP_STOP_SHARE_RECORD(0);

		display = FALSE;
	}

	if( m_pDevice ) {

		QCAP_STOP( m_pDevice );

		QCAP_DESTROY( m_pDevice );

		m_pDevice = NULL;
	}

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

void CSC5C0N1_VANCDlg::OnTimer(UINT nIDEvent) 
{
	if ( nIDEvent == 0x00000000 ) {

		KillTimer( 0x00000000 );

		if( (m_nVideoWidth == 0) || (m_nVideoHeight == 0) )
		{
			m_statInfo.SetWindowText( "INFO: ..." );

			if(display == TRUE)
			{
				QCAP_STOP_SHARE_RECORD(0);

				display = FALSE;
			}
		}
		else
		{
			m_statInfo.SetWindowText( (LPCTSTR)m_strFormatChangedOutput );

			if(display == TRUE)
			{
				QCAP_STOP_SHARE_RECORD(0);

				display = FALSE;
			}

			QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth, m_nVideoHeight, m_dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_DisplayWindow.m_hWnd, 1 );

			QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency );

			QCAP_START_SHARE_RECORD( 0, "", QCAP_RECORD_FLAG_DISPLAY);

			display = TRUE;
		}
	}
}
